/*  Errechnet die noch notwendige Arbeitszeit eines gegebenen Zeitslots (in Sekunden)

    Dabei wird die schon erledigte (gestempelte) Arbeitszeit, angefangen von älteren zu neueren Task-Einträgen, verteilt und
    dort von der geplanten (zu erledigenden) Arbeitszeit abgezogen.

    Beachtet auch, wenn der AG neu einterminiert wurde und zu diesem Zeitpunkt schon Zeit gestempelt war. Dann
    wird nämlich die bereits erledigte (gestempelte) Zeit bei der Terminierung wegegelassen.

    Die noch notwendige Arbeitszeit kann nur 0 oder postiv sein. Negative noch notwenige Arbeitszeit ist nicht zugelassen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__required_worktime__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__required_worktime__get(
      _tr_record scheduling.resource_timeline,
      _include_blocktimes_and_buffers     boolean DEFAULT true,
      _ab2__worktime_done__get            numeric DEFAULT -1, -- für Performance: PT.TPlantafelContainerDataSource_Core; wenn im äußeren TimeSlots bereits gegen ab2 gejoint, muss hier für die konstante ab2 nicht jedesmal ein Subselect pro Timeslot passieren.
      -- [x] DSC: Generell ist mir das eh unklar
      --> AXS: Es stimmt dass es performanter ist, bei konstanten AB2 die pro AG berechneten Werte als Parameter zu übergeben. Diese Funktion war aber auch dazu gedacht für einen spezifischen Timeline-Eintrag die noch notwendige Arbeitszeit dieses Eintrags auszurechenen ohne vorher die anderen Slots zu betrachten.
      --> AXS: Außerdem sollte sichergestellt werden, dass die Funktionen zu Berchnung der zum AG gehörenden Werte mit den korrekten Parametern gerufen werden. Insbesondere Funktion "ab2__required_worktime__get" mit Parameter "_include_stemp_time" = false.
      _ab2__required_worktime__get        numeric DEFAULT -1,  -- für Performance: Siehe Komentar zu "_ab2__worktime_done__get". WICHTIG Berechnung der notwendigen Arbeitszeit darf die Stempelungen nicht beachten bzw. abziehen (Parameter _include_stemp_time = false).
      _ab2__scheduled_time_get            numeric DEFAULT -1  -- für Ferformance: Siehe Komentar zu "_ab2__worktime_done__get".
  ) RETURNS numeric AS $$

  DECLARE

      _work_required_ti           numeric;
      _work_required_a2           numeric;
      _work_scheduled_ti          numeric;
      _work_scheduled_before_ti   numeric;
      _work_scheduled_a2          numeric;
      _work_scheduled_a2_missing  numeric;
      _work_done_a2               numeric;
      _work_done_a2_to_match      numeric;
      _work_done_ti               numeric;

  BEGIN
      IF _tr_record.ti_a2_id IS null THEN
         RETURN null;
      END IF;

      -- Geplante Arbeitszeit des ausgewählten Zeitslots (in Sekunden)
      _work_scheduled_ti := scheduling.resource_timeline__ab2__get_scheduled_time(
                                _ab2_id                         => _tr_record.ti_a2_id
                              , _ti_types                       =>  CASE
                                                                        WHEN _include_blocktimes_and_buffers
                                                                            THEN ARRAY[ 'task', 'task.buffer', 'task.blocktime' ]::scheduling.resource_timeline_blocktype[]
                                                                        ELSE ARRAY[ 'task' ]::scheduling.resource_timeline_blocktype[]
                                                                    END
                              , _timeframe_start                => _tr_record.ti_date_start
                              , _timeframe_end                  => _tr_record.ti_date_end
                              , _resource_id                    => _tr_record.ti_resource_id
                            );
      -- Erledigte Arbeitszeit des AG (in Sekunden)
      -- [x] DSC: Wieso wird das überhaupt immer gemacht? Wieso nicht nur, wenn wir uns in der Vergangenheit befinden, kommt mir spanisch vor. Wenn wir eine Woche 5 Slots haben, wird das für jeden Slot berechnet?
      --> AXS: Es könnte auch mehr gestempelt sein, als aktuell erledigt sein müsste oder Zeiten sind für AGe in der Zukunft gestempelt. Ansonsten siehe oben.
      IF _ab2__worktime_done__get = -1 THEN -- falls durch extern bereits berechnet (wegen JOIN ab2 effizienter als pro Slot/Record. Eine ab2 hat ja viele davon. UNKLAR
         _work_done_a2 := scheduling.ab2__worktime_done__get(
                                          _ab2_id => _tr_record.ti_a2_id
                                           );
      ELSE
         _work_done_a2 := _ab2__worktime_done__get;
      END IF;
      -- Geplante Arbeitszeit aller Zeitslots vor dem ausgewählten Zeitslots (in Sekunden)
      -- ... ist einfach die Summe der geplanten den Zeitslots des AG vor dem ausgewählten Zeitslot.
      -- ... gibt es keine Zeitslots vor dem dem ausgewählten Zeitslot ist der Wert Null.
      _work_scheduled_before_ti :=  scheduling.resource_timeline__ab2__get_scheduled_time(
                                        _ab2_id           => _tr_record.ti_a2_id
                                      , _ti_types => ARRAY[ 'task' ]::scheduling.resource_timeline_blocktype[]
                                      , _timeframe_start  => '-infinity'::timestamp
                                      , _timeframe_end    => _tr_record.ti_date_start - interval '1 second'
                                      , _resource_id      => _tr_record.ti_resource_id
                                    );

      -- Die notwendige Arbeitszeit des Arbeitsgangs unter Ignorierung schon erfolgter Stempelungen. (entspricht a2_ta)
      -- Wir wollen die Zeit wissen, welche verplant wurden sein sollte.
      IF _ab2__required_worktime__get = -1 THEN -- siehe Kommentierung IF _ab2__worktime_done__get = -1 THEN
          _work_required_a2 :=  scheduling.ab2__required_worktime__get(
                                    _ab2_id             => _tr_record.ti_a2_id
                                  , _include_stemp_time => false
                                 );
      ELSE
         _work_required_a2 := _ab2__required_worktime__get;
      END IF;
      -- Geplante Arbeitszeit für den Arbeitsgang.
      IF _ab2__scheduled_time_get = -1 THEN -- siehe Kommentierung IF _ab2__worktime_done__get = -1 THEN
          _work_scheduled_a2 := scheduling.resource_timeline__ab2__get_scheduled_time(
                                    _ab2_id => _tr_record.ti_a2_id
                                  , _ti_types => ARRAY[ 'task' ]::scheduling.resource_timeline_blocktype[]
                                  , _resource_id      => _tr_record.ti_resource_id
                            );
      ELSE
          _work_scheduled_a2 := _ab2__scheduled_time_get;
      END IF;

      -- Fehlende geplante Arbeitszeit, obwohl diese erforderlich gewesen wäre.
      -- Das kann regulär passieren, wenn ein AG terminiert wird, bei dem schon Zeit gestempelt war.
      -- Dann muss die zu diesem Zeitpunkt gestempelte Zeit nicht mehr mit einterminiert werden, da diese ja schon erledigt ist.
      _work_scheduled_a2_missing := _work_required_a2 - _work_scheduled_a2;
      -- Wenn mehr geplant wurde, als eigentlich erforderlich wäre, dann wollen wir keinen negativen Wert für fehlende geplante Arbeitszeit.
      IF _work_scheduled_a2_missing < 0 THEN
          _work_scheduled_a2_missing := 0;
      END IF;

      -- Die auf die Zeitslots zu verteilende erledigte Arbeitszeit
      -- ... ergibt sich aus der erledigten Arbeitszeit minus der fehlenden geplanten Arbeitszeit.
      _work_done_a2_to_match := _work_done_a2 - _work_scheduled_a2_missing;

      -- Schon erledigte Arbeitszeit des ausgewählten Zeitslots (in Sekunden)
      -- ... ergibt sich aus der erledigten Arbeitszeit, welche auf die Zeitslots verteilt werden soll, minus der Summe aller Zeitslots vor dem ausgewählten Zeitslot.
      _work_done_ti := _work_done_a2_to_match - _work_scheduled_before_ti;
      --  Die erledigte Arbeitszeit kann nur Null oder größer (positiv) sein!
      IF _work_done_ti < 0 THEN
          _work_done_ti := 0;
      END IF;

      -- Noch notwendige Arbeitszeit des ausgewählten Zeitslots (in Sekunden)
      -- ... ergibt sich aus der geplanten minus die erledigten Arbeitszeit des ausgewählten Zeitslots
      _work_required_ti := _work_scheduled_ti - _work_done_ti;
      -- Die noch notwendige Arbeitszeit kann nur Null oder größer (positiv) sein!
      IF _work_required_ti < 0 THEN
          _work_required_ti := 0;
      END IF;

      RETURN _work_required_ti;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;